﻿var ViewModel = function () {
    var self = this;
    self.assets = ko.observableArray();
    self.error = ko.observable();
    self.detail = ko.observable();
    self.calibrations = ko.observableArray();
    self.points = ko.observableArray();
    //self.newAsset = {
    //    nAssetUID: ko.observable(),
    //    Customer: ko.observable(),
    //    Manufacturer: ko.observable(),
    //    Model: ko.observable(),
    //    Description: ko.observable()
    //};

    var assetsUri = '/api/asset/';
    var usersUri = '/api/user/';
    var calibrationsUri = '/api/asset/listcalibrations/';
    var pointsUri = 'api/asset/listpointsmcrt/';

    function ajaxHelper(uri, method, data) {
        self.error(''); // Clear error message
        return $.ajax({
            type: method,
            url: uri,
            dataType: 'json',
            contentType: 'application/json',
            data: data ? JSON.stringify(data) : null
        }).fail(function (jqXHR, textStatus, errorThrown) {
            self.error(errorThrown);
        });
    }

    function getAllAssets() {
        ajaxHelper(assetsUri, 'GET').done(function (data) {
            self.assets(data);
        });
    }

    self.getAssetDetail = function (item) {
        self.points.removeAll();
        self.calibrations.removeAll();
        ajaxHelper(assetsUri + item.nAssetUID, 'GET').done(function (data) {
            self.detail(data);
        });
    };

    self.getCalibrations = function (item) {
        self.points.removeAll();
        ajaxHelper(calibrationsUri + item.nAssetUID, 'GET').done(function (data) {
            self.calibrations(data);
        });
    };

    self.getPoints = function (index) {
        ajaxHelper(pointsUri + self.calibrations()[index].nCallSheetResultUID, 'GET').done(function (data) {
            self.points(data);
        });
    };

    function getUsers() {
        ajaxHelper(usersUri, 'GET').done(function (data) {
            self.Users(data);
        });
    }

    //self.addAsset = function (formElement) {
    //    var asset = {
    //        nAssetUID: self.newAsset.nAssetUID(),
    //        Customer: self.newAsset.Customer().cFacilityName,
    //        Manufacturer: self.newAsset.Manufacturer().cFacilityName,
    //        Model: self.newAsset.Model(),
    //        Description: self.newAsset.Description()
    //    };

    //    ajaxHelper(assetsUri, 'POST', asset).done(function (item) {
    //        self.assets.push(item);
    //    });
    //};

    // Fetch the initial data.
    getAllAssets();
    //getUsers();
};

ko.applyBindings(new ViewModel());